<?php
require_once 'includes/connection.inc.php';
require_once 'includes/html_top.inc.php';
require_once "classes/OpenClinicaSoapWebService.php";


//read all the settings files
$settingFiles = array();
$dir = 'settings';
$cdir = scandir($dir);

foreach ($cdir as $key => $value)
{
	if (!in_array($value,array(".","..","example.inc.php")))
	{
		if (is_dir($dir . DIRECTORY_SEPARATOR . $value))
		{
			$settingFiles[$value] = dirToArray($dir . DIRECTORY_SEPARATOR . $value);
		}
		else
		{
			$settingFiles[] = $value;
		}
	}
}

?>

<p><h2>OpenClinica Status Monitor</h2></p>

<?php 
if (empty($settingFiles)) {
	echo '<span class="error">Missing settings file or no installed instances!</span>';
}
else{
?>

<table>
<thead>
<tr><td>OpenClinica Instance</td><td>Database connection</td></tr>
</thead>
<tbody>
<?php 
foreach($settingFiles as $files){
	include('settings/'.$files);

	echo '<tr><td>';
	echo $ocInstanceName;
	echo '</td><td>';
	//connect to the database
	try{
		$dbh = new PDO("pgsql:dbname=$db;host=$dbhost", $dbuser, $dbpass );
		if ($dbh){
			echo '<span class="success">DB connection successful</span>';
		}
	}catch(PDOException $e){
		echo '<span class="error">DB connection failed: '.$e->getMessage().'</span>';
	}
	
	echo '</td></tr>';
}

?>


</tbody>
</table>
<?php

}//end of $settingFiles is not empty

require_once 'includes/html_bottom.inc.php';
?>